# Sales Monitor Pro - WordPress Plugin

## תכונות
- 🔔 **Push Notifications** - התראה בטלפון עם צליל כסף בכל מכירה
- 📊 **דאשבורד מכירות** - יומי, חודשי, חיפוש לפי תאריך
- 👥 **גולשים בזמן אמת** - כמות + מקור תנועה (Google, Facebook, WhatsApp וכו')
- 📈 **גרף חודשי** - הזמנות + הכנסות per day
- 🛒 **מכירות אחרונות** - רשימה עם פרטי לקוח וסכום

---

## התקנה

### שלב 1 - העלאת הפלאגין
1. דחוס את תיקיית `sales-monitor-pro` ל-ZIP
2. WordPress Admin → פלאגינים → הוסף חדש → העלה פלאגין
3. הפעל את הפלאגין

### שלב 2 - הגדרת OneSignal (להתראות Push)

#### יצירת חשבון OneSignal (בחינם):
1. כנס ל-[onesignal.com](https://onesignal.com) וצור חשבון
2. צור **New App** → בחר **Web**
3. הכנס את שם האתר והדומיין שלך (למשל: `https://yoursite.com`)
4. בהגדרות OneSignal, העתק:
   - **App ID** (נראה כך: `xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx`)
   - **REST API Key** (מ: Settings → Keys & IDs)

#### הגדרה ב-WordPress:
1. Sales Monitor → הגדרות
2. הכנס App ID ו-REST API Key
3. שמור

### שלב 3 - אישור התראות בטלפון
1. פתח את האתר שלך בטלפון
2. האתר יבקש הרשאה לשלוח התראות - **אשר**
3. כעת בכל מכירה תקבל התראה עם צליל כסף!

---

## מבנה הפלאגין

```
sales-monitor-pro/
├── sales-monitor-pro.php         # Plugin main file
├── includes/
│   ├── class-database.php        # DB tables & queries
│   ├── class-push-notifications.php  # OneSignal integration
│   ├── class-woo-integration.php # WooCommerce hooks
│   ├── class-visitors.php        # Real-time visitor tracking
│   └── class-rest-api.php        # REST endpoints
├── admin/
│   ├── dashboard.php             # Dashboard HTML
│   └── settings.php              # Settings page
└── assets/
    ├── js/
    │   ├── dashboard.js          # Dashboard logic + Chart.js
    │   ├── visitor-tracker.js    # Frontend tracking
    │   └── push-subscription.js  # OneSignal + cash sound
    └── css/
        └── dashboard.css         # RTL Hebrew UI
```

---

## REST API Endpoints

| Endpoint | תיאור |
|----------|-------|
| `GET /wp-json/smp/v1/sales/today` | מכירות היום |
| `GET /wp-json/smp/v1/sales/day/YYYY-MM-DD` | מכירות לפי יום |
| `GET /wp-json/smp/v1/sales/month?year=&month=` | מכירות חודשיות |
| `GET /wp-json/smp/v1/visitors/live` | גולשים פעילים |
| `GET /wp-json/smp/v1/sales/recent` | מכירות אחרונות |

---

## דרישות
- WordPress 5.6+
- WooCommerce 5.0+
- PHP 7.4+
- HTTPS (חובה לPush Notifications)

---

## צליל כסף
הצליל מיוצר ב-JavaScript נטו עם Web Audio API - אין קובץ צליל חיצוני.  
עובד על Chrome, Firefox, Safari, Edge.

---

## Notes
- גולשים "פעילים" = גולשים שנראו ב-5 הדקות האחרונות
- הדאשבורד מתרענן אוטומטית כל 30 שניות
- Transient cache: 60 שניות להיום, 5 דקות לחודש
