<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<div class="smp-wrap" dir="rtl">

    <!-- Header -->
    <div class="smp-header">
        <div class="smp-header-left">
            <div class="smp-logo">💰</div>
            <div>
                <h1>Sales Monitor Pro</h1>
                <p>ניטור מכירות וגולשים בזמן אמת</p>
            </div>
        </div>
        <div class="smp-header-right">
            <div id="smp-live-badge" class="smp-live-badge">
                <span class="smp-pulse"></span>
                <span id="smp-visitor-count">0</span> גולשים פעילים
            </div>
        </div>
    </div>

    <!-- KPI Cards -->
    <div class="smp-kpi-grid">
        <div class="smp-kpi-card smp-kpi-today">
            <div class="smp-kpi-icon">📦</div>
            <div class="smp-kpi-data">
                <div class="smp-kpi-value" id="kpi-today-orders">—</div>
                <div class="smp-kpi-label">הזמנות היום</div>
            </div>
        </div>
        <div class="smp-kpi-card smp-kpi-revenue">
            <div class="smp-kpi-icon">₪</div>
            <div class="smp-kpi-data">
                <div class="smp-kpi-value" id="kpi-today-revenue">—</div>
                <div class="smp-kpi-label">הכנסות היום</div>
            </div>
        </div>
        <div class="smp-kpi-card smp-kpi-month">
            <div class="smp-kpi-icon">📅</div>
            <div class="smp-kpi-data">
                <div class="smp-kpi-value" id="kpi-month-orders">—</div>
                <div class="smp-kpi-label">הזמנות החודש</div>
            </div>
        </div>
        <div class="smp-kpi-card smp-kpi-month-rev">
            <div class="smp-kpi-icon">💎</div>
            <div class="smp-kpi-data">
                <div class="smp-kpi-value" id="kpi-month-revenue">—</div>
                <div class="smp-kpi-label">הכנסות החודש</div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="smp-row">
        <!-- Monthly Chart -->
        <div class="smp-card smp-card-wide">
            <div class="smp-card-header">
                <h2>📈 מכירות חודשיות</h2>
                <div class="smp-month-nav">
                    <button id="smp-prev-month" class="smp-btn-small">&#8249;</button>
                    <span id="smp-current-month"></span>
                    <button id="smp-next-month" class="smp-btn-small">&#8250;</button>
                </div>
            </div>
            <canvas id="smp-monthly-chart" height="100"></canvas>
        </div>

        <!-- Live Visitors -->
        <div class="smp-card">
            <div class="smp-card-header">
                <h2>👥 גולשים פעילים</h2>
                <span class="smp-refresh-badge" id="smp-last-refresh">עודכן עכשיו</span>
            </div>
            <div id="smp-channels-grid" class="smp-channels-grid"></div>
            <div class="smp-visitors-list-wrap">
                <h3>דפים פעילים</h3>
                <div id="smp-visitors-list"></div>
            </div>
        </div>
    </div>

    <!-- Day Picker + Recent Sales -->
    <div class="smp-row">
        <!-- Day Picker -->
        <div class="smp-card">
            <div class="smp-card-header">
                <h2>🔍 חיפוש לפי יום</h2>
            </div>
            <div class="smp-day-picker">
                <input type="date" id="smp-date-picker" value="<?php echo esc_attr( date('Y-m-d') ); ?>" />
                <button id="smp-search-day" class="smp-btn-primary">חפש</button>
            </div>
            <div id="smp-day-result" class="smp-day-result" style="display:none">
                <div class="smp-day-kpi">
                    <span class="smp-day-kpi-val" id="day-orders">—</span>
                    <span class="smp-day-kpi-lbl">הזמנות</span>
                </div>
                <div class="smp-day-kpi">
                    <span class="smp-day-kpi-val" id="day-revenue">—</span>
                    <span class="smp-day-kpi-lbl">הכנסות</span>
                </div>
            </div>
        </div>

        <!-- Recent Sales -->
        <div class="smp-card smp-card-wide">
            <div class="smp-card-header">
                <h2>🛒 מכירות אחרונות</h2>
            </div>
            <div class="smp-table-wrap">
                <table class="smp-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>תאריך</th>
                            <th>לקוח</th>
                            <th>סכום</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody id="smp-recent-sales"></tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Push Notification Test Button -->
    <div class="smp-card smp-push-test-card">
        <div class="smp-card-header">
            <h2>🔔 בדיקת התראות Push</h2>
        </div>
        <p>לחץ על הכפתור לשלוח התראת בדיקה לכל המנויים:</p>
        <button id="smp-test-push" class="smp-btn-primary">שלח התראת בדיקה 🔔</button>
        <div id="smp-push-result"></div>
        <div class="smp-push-info">
            <strong>לאפשר התראות בדפדפן שלך:</strong>
            <button id="smp-enable-push" class="smp-btn-secondary">הפעל התראות 🔔</button>
        </div>
    </div>

</div>
