<?php
if ( ! defined( 'ABSPATH' ) ) exit;

// שמור הגדרות
if ( isset( $_POST['smp_save_settings'] ) && check_admin_referer( 'smp_settings' ) ) {
    $settings = [
        'push_method'        => sanitize_text_field( $_POST['push_method'] ),
        'onesignal_app_id'   => sanitize_text_field( $_POST['onesignal_app_id'] ),
        'onesignal_api_key'  => sanitize_text_field( $_POST['onesignal_api_key'] ),
        'onesignal_safari'   => sanitize_text_field( $_POST['onesignal_safari'] ?? '' ),
        'vapid_public'       => sanitize_text_field( $_POST['vapid_public'] ?? '' ),
        'vapid_private'      => sanitize_textarea_field( $_POST['vapid_private'] ?? '' ),
        'notification_sound' => sanitize_text_field( $_POST['notification_sound'] ?? 'cash' ),
        'notification_title' => sanitize_text_field( $_POST['notification_title'] ?? '💰 מכירה חדשה!' ),
    ];
    update_option( 'smp_settings', $settings );
    echo '<div class="notice notice-success"><p>✅ ההגדרות נשמרו בהצלחה!</p></div>';
}

$settings = get_option( 'smp_settings', [] );
$push_method = $settings['push_method'] ?? 'onesignal';
?>
<div class="smp-wrap" dir="rtl">
    <div class="smp-header">
        <div class="smp-header-left">
            <div class="smp-logo">⚙️</div>
            <div>
                <h1>הגדרות Sales Monitor</h1>
                <p>קונפיגורציה של התראות ועיצוב</p>
            </div>
        </div>
    </div>

    <form method="post" action="">
        <?php wp_nonce_field('smp_settings'); ?>

        <!-- Push Method -->
        <div class="smp-card">
            <div class="smp-card-header"><h2>🔔 שיטת Push Notifications</h2></div>
            <div class="smp-settings-group">
                <label class="smp-radio-label">
                    <input type="radio" name="push_method" value="onesignal" <?php checked($push_method,'onesignal'); ?>>
                    <strong>OneSignal</strong> (מומלץ - בחינם, קל להגדרה)
                </label>
                <label class="smp-radio-label">
                    <input type="radio" name="push_method" value="webpush" <?php checked($push_method,'webpush'); ?>>
                    <strong>Web Push ידני</strong> (VAPID - מתקדם)
                </label>
            </div>
        </div>

        <!-- OneSignal Settings -->
        <div class="smp-card" id="onesignal-settings">
            <div class="smp-card-header">
                <h2>🟡 הגדרות OneSignal</h2>
                <a href="https://onesignal.com" target="_blank" class="smp-btn-small">פתח OneSignal ↗</a>
            </div>
            <div class="smp-settings-info">
                <strong>הוראות:</strong>
                <ol>
                    <li>צור חשבון בחינם ב-<a href="https://onesignal.com" target="_blank">OneSignal.com</a></li>
                    <li>צור אפליקציה חדשה (Web Push)</li>
                    <li>הכנס את ה-App ID ו-REST API Key למטה</li>
                    <li>הוסף את הדומיין שלך בהגדרות OneSignal</li>
                </ol>
            </div>
            <div class="smp-settings-row">
                <label>App ID</label>
                <input type="text" name="onesignal_app_id" value="<?php echo esc_attr($settings['onesignal_app_id'] ?? ''); ?>" placeholder="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx" class="regular-text" />
            </div>
            <div class="smp-settings-row">
                <label>REST API Key</label>
                <input type="text" name="onesignal_api_key" value="<?php echo esc_attr($settings['onesignal_api_key'] ?? ''); ?>" placeholder="Your REST API Key" class="regular-text" />
            </div>
        </div>

        <!-- Notification Settings -->
        <div class="smp-card">
            <div class="smp-card-header"><h2>🎵 הגדרות ההתראה</h2></div>
            <div class="smp-settings-row">
                <label>כותרת ההתראה</label>
                <input type="text" name="notification_title" value="<?php echo esc_attr($settings['notification_title'] ?? '💰 מכירה חדשה!'); ?>" class="regular-text" />
            </div>
            <div class="smp-settings-row">
                <label>צליל</label>
                <select name="notification_sound">
                    <option value="cash" <?php selected($settings['notification_sound']??'cash','cash'); ?>>💰 Cash Register</option>
                    <option value="ding" <?php selected($settings['notification_sound']??'','ding'); ?>>🔔 Ding</option>
                    <option value="default" <?php selected($settings['notification_sound']??'','default'); ?>>Default</option>
                </select>
                <button type="button" id="test-sound" class="smp-btn-small" onclick="smpPlaySound()">▶ בדוק צליל</button>
            </div>
        </div>

        <div class="smp-settings-actions">
            <button type="submit" name="smp_save_settings" class="smp-btn-primary">💾 שמור הגדרות</button>
        </div>
    </form>
</div>

<script>
function smpPlaySound() {
    const ctx = new AudioContext();
    // Cash register sound simulation
    const frequencies = [800, 1000, 1200, 1000, 800, 600];
    let time = ctx.currentTime;
    frequencies.forEach((freq, i) => {
        const osc = ctx.createOscillator();
        const gain = ctx.createGain();
        osc.connect(gain);
        gain.connect(ctx.destination);
        osc.frequency.value = freq;
        osc.type = 'sine';
        gain.gain.setValueAtTime(0.3, time);
        gain.gain.exponentialRampToValueAtTime(0.001, time + 0.15);
        osc.start(time);
        osc.stop(time + 0.15);
        time += 0.1;
    });
}
</script>
