/* Sales Monitor Pro - Push Subscription + Cash Sound */
(function () {
    'use strict';

    /* ─── Cash Register Sound ─── */
    window.smpPlayCashSound = function () {
        try {
            const ctx = new (window.AudioContext || window.webkitAudioContext)();

            const notes = [
                { freq: 1200, start: 0.00, dur: 0.08 },
                { freq: 1400, start: 0.07, dur: 0.08 },
                { freq: 1600, start: 0.14, dur: 0.08 },
                { freq: 1800, start: 0.21, dur: 0.10 },
                { freq: 2000, start: 0.28, dur: 0.12 },
                // "ding" coin drop
                { freq: 900,  start: 0.44, dur: 0.25 },
                { freq: 850,  start: 0.48, dur: 0.30 },
            ];

            notes.forEach(({ freq, start, dur }) => {
                const osc  = ctx.createOscillator();
                const gain = ctx.createGain();
                osc.connect(gain);
                gain.connect(ctx.destination);

                osc.type            = freq > 1000 ? 'square' : 'sine';
                osc.frequency.value = freq;
                gain.gain.setValueAtTime(0.0, ctx.currentTime + start);
                gain.gain.linearRampToValueAtTime(0.25, ctx.currentTime + start + 0.01);
                gain.gain.exponentialRampToValueAtTime(0.001, ctx.currentTime + start + dur);
                osc.start(ctx.currentTime + start);
                osc.stop(ctx.currentTime + start + dur + 0.05);
            });
        } catch (e) {
            console.log('SMP: AudioContext not available');
        }
    };

    /* ─── OneSignal Push Init ─── */
    const pushData = window.smpPushData || {};
    if (!pushData.oneSignalAppId) return;

    // Load OneSignal SDK
    window.OneSignalDeferred = window.OneSignalDeferred || [];

    const script = document.createElement('script');
    script.src   = 'https://cdn.onesignal.com/sdks/web/v16/OneSignalSDK.page.js';
    script.defer = true;
    document.head.appendChild(script);

    window.OneSignalDeferred.push(async function(OneSignal) {
        await OneSignal.init({
            appId:                        pushData.oneSignalAppId,
            notifyButton:                 { enable: false },
            allowLocalhostAsSecureOrigin: true,
        });

        // Auto-prompt only for admins (WP body class check)
        if (document.body.classList.contains('logged-in')) {
            OneSignal.User.PushSubscription.optIn();
        }

        // Tag admin users so we can target them
        OneSignal.User.addTag('role', 'admin');

        // Listen for incoming push and play sound
        OneSignal.Notifications.addEventListener('click', (event) => {
            if (event.notification.data && event.notification.data.sound === 'cash_register') {
                window.smpPlayCashSound();
            }
        });

        // Also play on foreground notification (when browser is open)
        OneSignal.Notifications.addEventListener('foregroundWillDisplay', (event) => {
            window.smpPlayCashSound();
            event.notification.display();
        });
    });

})();
