/* Sales Monitor Pro - Visitor Tracker (Frontend) */
(function () {
    'use strict';

    const data = window.smpTrackerData || {};
    if (!data.ajaxUrl || !data.sessionId) return;

    /* ─── Track pageview on load ─── */
    function trackPageview() {
        const fd = new FormData();
        fd.append('action',     'smp_track_visitor');
        fd.append('nonce',      data.nonce);
        fd.append('session_id', data.sessionId);
        fd.append('page_url',   data.pageUrl || window.location.href);
        fd.append('page_title', data.pageTitle || document.title);
        fd.append('referrer',   document.referrer || '');

        fetch(data.ajaxUrl, { method: 'POST', body: fd }).catch(() => {});
    }

    /* ─── Heartbeat every 60s to keep session alive ─── */
    function heartbeat() {
        const fd = new FormData();
        fd.append('action',     'smp_heartbeat');
        fd.append('nonce',      data.nonce);
        fd.append('session_id', data.sessionId);
        fetch(data.ajaxUrl, { method: 'POST', body: fd }).catch(() => {});
    }

    trackPageview();
    setInterval(heartbeat, 60000);

})();
