<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class SMP_Woo_Integration {

    public function __construct() {
        // פעל רק אם WooCommerce פעיל
        if ( ! class_exists( 'WooCommerce' ) ) return;

        // הזמנה חדשה / סטטוס שינה לprocessing
        add_action( 'woocommerce_order_status_processing', [ $this, 'on_new_order' ], 10, 1 );
        add_action( 'woocommerce_order_status_completed',  [ $this, 'on_new_order' ], 10, 1 );
        add_action( 'woocommerce_checkout_order_processed', [ $this, 'on_new_order' ], 10, 1 );
    }

    public function on_new_order( $order_id ) {
        // מנע כפילויות - בדוק אם כבר שלחנו התראה
        $already_notified = get_post_meta( $order_id, '_smp_notified', true );
        if ( $already_notified ) return;

        update_post_meta( $order_id, '_smp_notified', current_time('mysql') );

        // שלח Push Notification
        do_action( 'smp_send_sale_notification', $order_id );

        // עדכן נתוני מכירות בcache
        delete_transient( 'smp_today_stats' );
        delete_transient( 'smp_month_stats_' . date('Y_m') );
    }
}
