<?php
/**
 * Plugin Name: Sales Monitor Pro
 * Plugin URI:  https://yoursite.com
 * Description: ניטור מכירות בזמן אמת עם התראות Push, דאשבורד מכירות וניטור גולשים חיים
 * Version:     1.0.0
 * Author:      Your Name
 * Text Domain: sales-monitor-pro
 * Domain Path: /languages
 * Requires WC: 5.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'SMP_VERSION',     '1.0.0' );
define( 'SMP_PLUGIN_DIR',  plugin_dir_path( __FILE__ ) );
define( 'SMP_PLUGIN_URL',  plugin_dir_url( __FILE__ ) );
define( 'SMP_PLUGIN_FILE', __FILE__ );

/* ─── Autoload ─── */
require_once SMP_PLUGIN_DIR . 'includes/class-database.php';
require_once SMP_PLUGIN_DIR . 'includes/class-push-notifications.php';
require_once SMP_PLUGIN_DIR . 'includes/class-woo-integration.php';
require_once SMP_PLUGIN_DIR . 'includes/class-visitors.php';
require_once SMP_PLUGIN_DIR . 'includes/class-rest-api.php';

/* ─── Bootstrap ─── */
function smp_init() {
    SMP_Database::install();
    new SMP_Push_Notifications();
    new SMP_Woo_Integration();
    new SMP_Visitors();
    new SMP_Rest_API();
}
add_action( 'plugins_loaded', 'smp_init' );

/* ─── Activation / Deactivation ─── */
register_activation_hook(   __FILE__, [ 'SMP_Database', 'install' ] );
register_deactivation_hook( __FILE__, [ 'SMP_Database', 'uninstall' ] );

/* ─── Admin Menu ─── */
add_action( 'admin_menu', function () {
    add_menu_page(
        'Sales Monitor Pro',
        'Sales Monitor',
        'manage_woocommerce',
        'sales-monitor-pro',
        'smp_render_dashboard',
        'dashicons-chart-line',
        56
    );
    add_submenu_page(
        'sales-monitor-pro',
        'הגדרות',
        'הגדרות',
        'manage_woocommerce',
        'smp-settings',
        'smp_render_settings'
    );
} );

function smp_render_dashboard() {
    include SMP_PLUGIN_DIR . 'admin/dashboard.php';
}
function smp_render_settings() {
    include SMP_PLUGIN_DIR . 'admin/settings.php';
}

/* ─── Admin Assets ─── */
add_action( 'admin_enqueue_scripts', function ( $hook ) {
    if ( strpos( $hook, 'sales-monitor' ) === false ) return;

    wp_enqueue_style(  'smp-dashboard', SMP_PLUGIN_URL . 'assets/css/dashboard.css', [], SMP_VERSION );
    wp_enqueue_script( 'smp-chart',     'https://cdn.jsdelivr.net/npm/chart.js@4/dist/chart.umd.min.js', [], null, true );
    wp_enqueue_script( 'smp-dashboard', SMP_PLUGIN_URL . 'assets/js/dashboard.js', [ 'jquery', 'smp-chart' ], SMP_VERSION, true );

    wp_localize_script( 'smp-dashboard', 'smpData', [
        'apiUrl'   => rest_url( 'smp/v1/' ),
        'nonce'    => wp_create_nonce( 'wp_rest' ),
        'ajaxUrl'  => admin_url( 'admin-ajax.php' ),
        'currency' => get_woocommerce_currency_symbol(),
    ] );
} );

/* ─── Frontend Assets (visitor tracking + push) ─── */
add_action( 'wp_enqueue_scripts', function () {
    $settings = get_option( 'smp_settings', [] );

    wp_enqueue_script( 'smp-tracker', SMP_PLUGIN_URL . 'assets/js/visitor-tracker.js', [], SMP_VERSION, true );
    wp_localize_script( 'smp-tracker', 'smpTrackerData', [
        'ajaxUrl'    => admin_url( 'admin-ajax.php' ),
        'nonce'      => wp_create_nonce( 'smp_tracker' ),
        'sessionId'  => smp_get_session_id(),
        'pageTitle'  => get_the_title(),
        'pageUrl'    => get_permalink(),
    ] );

    // Push subscription script (frontend)
    if ( ! empty( $settings['onesignal_app_id'] ) ) {
        wp_enqueue_script( 'smp-push', SMP_PLUGIN_URL . 'assets/js/push-subscription.js', [], SMP_VERSION, true );
        wp_localize_script( 'smp-push', 'smpPushData', [
            'oneSignalAppId' => $settings['onesignal_app_id'],
        ] );
    }
} );

/* ─── Helper: unique session ID ─── */
function smp_get_session_id() {
    if ( ! session_id() ) @session_start();
    if ( empty( $_SESSION['smp_session_id'] ) ) {
        $_SESSION['smp_session_id'] = wp_generate_uuid4();
    }
    return $_SESSION['smp_session_id'];
}
